﻿using inetsoftware.Config;
using inetsoftware.Reporting;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace inetsoftware
{
    /// <summary>
    /// This sample render a rpt file in the HTML format and write all to files.
    /// </summary>
    public class HtmlExport
    {
        static HtmlExport()
        {
            // set license once from environment if required.
            string license = Environment.GetEnvironmentVariable("ICR_LICENSE");
            if (!string.IsNullOrEmpty(license))
            {
                ConfigurationManager.Instance.Current["licensekey"] = license;
            }
        }

        public static void Main(string[] args)
        {
            Engine eng = new Engine(Engine.EXPORT_HTML);
            eng.ReportFile = @"samples\resources\Sample.rpt";
            eng.Execute();

            string path = @"Sample\";
            System.IO.Directory.CreateDirectory(path);

            int count = eng.PageCount;
            for (int i = 1; i <= count; i++)
            {
                byte[] chunkData = eng.PageData(i);
                int idx = 0;
                while (idx < chunkData.Length)
                {
                    int length = readHtmlInt(chunkData, idx);
                    if (length == -1)
                    {
                        break;
                    }
                    idx += 4;

                    // file name is encoded with UTF8, it needs to be decoded here with UTF8
                    String chunkName = System.Text.Encoding.UTF8.GetString(chunkData, idx, length);
                    chunkName = path + chunkName;
                    idx += length;

                    length = readHtmlInt(chunkData, idx);
                    idx += 4;

                    using (FileStream stream = new FileStream(chunkName, FileMode.Create))
                    {
                        stream.Write(chunkData, idx, length);
                    }
                    idx += length;
                }

            }
        }

        private static int readHtmlInt(byte[] data, int off)
        {
            if (off + 4 > data.Length)
            {
                throw new InvalidOperationException("Invalid HTML data: length=" + data.Length + " at " + off);
            }
            return (data[off] & 0xFF) | ((data[off + 1] & 0xFF) << 8) | ((data[off + 2] & 0xFF) << 16) | ((data[off + 3]) << 24);
        }
    }
}
